*
* INCOMING IP DATAGRAM PROCESSING
*
* CHECK AN IP PACKET AND RETURN SOME INFORMATION ABOUT ITS
* CONTENTS. REJECT PACKETS THAT WE DON'T AGREE WITH.
*
BCASTFLAG DFB 0 ; INCOMING DATAGRAM WAS BROADCAST
LLBCASTFLAG DFB 0 ; INCOMING PACKET WAS LINK BROADCAST
IPINSRC DS 4 ; INCOMING SOURCE ADDRESS
IPHEAD DS 2 ; POINTER TO IP HEAD
*
HANDLEIP
 INC IPCOUNT ; INCOMING PACKET COUNTER
 BNE :NEXT
 INC IPCOUNT+1
:NEXT CLC
 LDA INPBUF ; ADVANCE THE POINTER...
 ADC #ETHHLEN ; ...14 BYTES TO THE IP DATA
 STA INPBUF
 STA IPHEAD
 LDA INPBUF+1
 ADC #0
 STA INPBUF+1
 STA IPHEAD+1
*
* CHECK VERSION AND HEADER LENGTH
* WE ACCEPT, BUT DO NOT PROCESS, IP OPTIONS.
* BUT WE DO SAVE THE ADVERTISED HEADER LENGTH.
*
 LDY #0 ; POINT AT VERS/HL FIELD
 LDA (INPBUF),Y
 TAX ; SAVE FOR OUR NEXT TEST
 AND #$F0 ; MASK OUT THE HEADER LENGTH
 CMP #$40 ; IP VERSION 4
 BEQ :NEXT2
 JMP :BADHEAD ; UNRECOGNIZED VERSION
:NEXT2 TXA ; GET THE ORIGINAL VALUE BACK TO TEST AGAIN
 AND #%00001111 ; NOW MASK OUT THE VERSION
 ASL ; SHIFT LEFT TO GET THE BYTE VALUE,
 ASL  ; WHICH HAS A MAXIMUM VALUE OF $3C.
 STA IPHEADLEN
 CMP #20
 BCS :VERADDR
* HEAD TOO SHORT
 LDA #$55
 JMP :BADHEAD ; DISCARD
*
* DON'T ALLOW DATAGRAMS WITH A SOURCE OR DESTINATION
* ADDRESS IN THE LOOPBACK NETWORK (127).
*
:VERADDR
 LDY #12 ; SOURCE ADDR
 LDA (INPBUF),Y
 CMP #127
 BNE :VERADDR2
 JMP :BADHEAD2 ; THE DEVIL SENT THIS
:VERADDR2 LDY #16 ; DESTINATION ADDR
 LDA (INPBUF),Y
 CMP #127
 BNE :VERADDR3
 JMP :BADHEAD2
*
* DESTINATION ADDRESS MATCHES OUR ADDRESS?
*
:VERADDR3
 LDA #0
 STA BCASTFLAG
 LDY #19 ; DESTINATION OFFSET
 LDX #3 ; IPADDR OFFSET
:VADL LDA (INPBUF),Y
 CMP IPADDR,X
 BNE :VERADDR4 ; NO MATCH, MOVE ON
 DEY
 DEX
 BPL :VADL
 BMI :VERIFY ; IT WAS ADDRESSED TO US
*
* DESTINATION IS BROADCAST?
* FIRST CHECK 255.255.255.255 THEN CHECK NETBCAST
*
:VERADDR4
 LDY #19
 LDX #3
:VADL2 LDA (INPBUF),Y
 CMP #255
 BNE :VERNBCAST
 DEY
 DEX
 BPL :VADL2
* IF WE GET HERE THEN IT WAS A LIMITED BROADCAST
 BMI :SETBF
* CHECK FOR A SUBNET DIRECTED BROADCAST
:VERNBCAST
 LDY #19
 LDX #3 ; NETBCAST OFFSET
:VBCL LDA (INPBUF),Y
 CMP NETBCAST,X
 BNE :VERADDR5 ; NOT BROADCAST
 DEY
 DEX
 BPL :VBCL
:SETBF LDA #1
 STA BCASTFLAG
 BPL :VERIFY ; IT WAS A BROADCAST
*
* NON-STANDARD BROADCAST ADDRESS: 0.0.0.0
* ALSO CALLED THE BERKELEY BROADCAST; SEE RFC 1122
*
:VERADDR5
 LDY #19
 LDA (INPBUF),Y
 DEY
 ORA (INPBUF),Y
 DEY
 ORA (INPBUF),Y
 DEY
 ORA (INPBUF),Y
 BEQ :SETBF ; IT WAS A BROADCAST
*
* NOW HERE IS OUR SPECIAL-CASE CODE FOR DHCP REPLIES
 LDA IPCONFMODE
 BPL :VERADDR6 ; HIGH-BIT IS CLEAR
 CMP #%10000000 ; LINK-LOCAL CONFIGURED
 BEQ :VERADDR6
 JMP :BADHEAD2
:VERADDR6
 LDA IPHEADLEN
 CMP #20
 BEQ :VERADDR7
 JMP :BADHEAD2
:VERADDR7
 LDY #9 ; POINT TO PROTOCOL
 LDA (INPBUF),Y
 CMP #17 ; MUST BE UDP
 BEQ :VERADDR8
 JMP :BADHEAD2
:VERADDR8
 LDY #22 ; UDP DEST PORT
 LDA (INPBUF),Y
 BEQ :VERADDR9
 JMP :BADHEAD2
:VERADDR9
 INY
 LDA (INPBUF),Y
 CMP #68 ; BOOTP CLIENT PORT
 BEQ :VERIFY
 JMP :BADHEAD2
*
* RFC 1122, PAGE 67: A HOST SHOULD SILENTLY DISCARD A
* DATAGRAM RECEIVED VIA LL BROADCAST, BUT NOT ADDRESSED
* TO A BROADCAST OR MULTICAST ADDRESS.
:VERIFY
 LDA LLBCASTFLAG
 BEQ :VERIFY2 ; WAS NOT LL BROADCAST
 LDA BCASTFLAG
 BNE :VERIFY2 ; BROADCAST FLAG SET-- OK.
 JMP :BADHEAD2 ; NOT BROADCAST-- BAD.
*
* VERIFY THE CHECKSUM
* THIS USES A ROUTINE OPTIMIZED FOR 20-BYTE HEADERS.
* THE INTERESTING PROPERTY ABOUT THE CHECKSUM IS THAT WHEN
* WE RECOMPUTE IT, WE SHOULD GET A RESULT OF ZERO. THAT'S
* BECAUSE THE CHECKSUM VALUE IN THE HEADER IS A NEGATIVE
* NUMBER THAT CANCELS OUT THE SUM OF THE OTHER 18 BYTES.
*
:VERIFY2
 LDA IPHEADLEN
 CMP #20 ; CHECK FOR STANDARD LENGTH
 BNE :VERIFY4 ; NON-STANDARD IP HEAD LENGTH
 LDA INPBUF
 STA PTR
 LDA INPBUF+1
 STA PTR+1
 JSR IPHEADCHKSUM
:VERIFY3 ORA CHKSUM+1 ; A-REG ALREADY LOADED
 BNE :BADCHKSUM ; NOT ZERO? THAT'S BAD
* CHECKSUM IS OK, SO PRINT A PLUS SIGN
 DO DEBUG
 LDA #"+"
 JSR COUT
 FIN
 JMP :CHECKSEC
* FALLBACK TO STANDARD CHECKSUM ROUTINE FOR >20 BYTES
:VERIFY4
 STA CHKSUMLEN ; IPHEADLEN
 LDA #0
 STA CHKSUMLEN+1
 STA CHKSUM ; WE HAVE TO CLEAR CHKSUM
 STA CHKSUM+1
 LDA INPBUF
 STA PTR2
 LDA INPBUF+1
 STA PTR2+1
 CLC
 JSR UDPCHKSUM2
 BCC :VERIFY3 ; ALWAYS TAKEN
* CHECKSUM IS DIRTY, SO WASH OUR HANDS OF THIS PACKET!
:BADCHKSUM
 DO DEBUG
 LDA #"@" ; SCREAM!
 JSR COUT
* DEBUG
 LDA #$66
 FIN
 JMP :BADHEAD
* RFC 3514 SECURITY BIT
:CHECKSEC  LDY #6 ; POINT TO FLAGS
 LDA (INPBUF),Y
 BPL :FRAG ; HIGH-BIT NOT SET
* DEBUG
 LDA #$77
 JMP :BADHEAD ; SECURITY BIT IS SET!
*
* FRAGMENTATION
:FRAG
 AND #%00100000 ; MORE FRAGMENTS BIT
 BEQ :COPYSRC
 DO DEBUG
 LDA #"F"
 JSR COUT
 FIN
*
* COPY SOURCE ADDRESS FOR LATER USE
*
:COPYSRC
 LDY #15 ; OFFSET TO SOURCE ADDR
 LDX #3 ; IPINSRC OFFSET
:CSL LDA (INPBUF),Y
 STA IPINSRC,X
 DEY
 DEX
 BPL :CSL
*
* PRINT THE PROTOCOL
*
:PRINTPRO
 DO DEBUG
 LDA #" "
 JSR COUT
 LDY #0
:L LDA MSG8,Y
 BEQ :GETPRO
 JSR COUT
 INY
 BNE :L
 FIN
:GETPRO LDY #9 ; POINT TO PROTOCOL FIELD
 LDA (INPBUF),Y
 CMP #PROTOICMP ; ICMP
 BEQ :ISICMP
 CMP #PROTOTCP ; TCP
 BEQ :ISTCP
 CMP #PROTOUDP ; UDP
 BEQ :ISUDP
*
* UNSUPPORTED PROTOCOL
* SEND AN ICMP ERROR
* TYPE 3, CODE 2
*
 LDA #ICMPUNREACH
 STA ICMPERRTYPE
 LDA #2
 STA ICMPERRCODE
 JSR ICMPERROR

* BELOW IS ALL DEBUG CODE
 DO DEBUG
 LDA #"?" ; UNKNOWN PROTOCOL
 JSR COUT
 LDA #"?"
 JSR COUT
 LDA #"?"
 JSR COUT
 FIN
*
 RTS
:ISICMP
 DO DEBUG
 LDA #"I"
 JSR COUT
 LDA #"C"
 JSR COUT
 LDA #"M"
 JSR COUT
 LDA #"P"
 JSR COUT
 FIN

 JSR HANDLEICMP
 RTS
:ISTCP
 DO DEBUG
 LDA #"T"
 JSR COUT
 LDA #"C"
 JSR COUT
 LDA #"P"
 JSR COUT
 FIN

 JSR HANDLETCP
 RTS
:ISUDP
 DO DEBUG
 LDA #"U"
 JSR COUT
 LDA #"D"
 JSR COUT
 LDA #"P"
 JSR COUT
 FIN

 JSR HANDLEUDP
 RTS
:BADHEAD
*
* DEBUG
*
 DO DEBUG
 LDA #" "
 JSR COUT
 LDA CHKSUM+1
 LDX CHKSUM
 JSR PRNTAX
*
 JSR CROUT
 LDA #"B"
 JSR COUT
 LDA #"A"
 JSR COUT
 LDA #"D"
 JSR COUT
 FIN
:BADHEAD2 SEC  ; FLAG AN ERROR
 DO DEBUG
 LDA #"^"
 JSR COUT ; DEBUG
 LDA #" "
 JSR COUT
 FIN
 RTS
*
*
* IP TRANSMIT ROUTINES
*
*
MAXTTL EQU 255 ; MAXIMUM VALUE FOR TTL
STDTTL EQU 64 ; STANDARD VALUE FOR TTL
MCASTTTL EQU 1 ; RFC 1112, SECTION 6.1
MCASTCLASS EQU %11100000 ; CLASS D, ONLY HIGH NYBBLE MATTERS
*
ROUTER DS 4 ; GATEWAY FOR NON-LOCAL DATAGRAMS
NAMESERVER1 DS 4 ; PRIMARY DNS SERVER
NAMESERVER2 DS 4 ; SECONDARY DNS SERVER
OUTPBUFSAV DS 2 ; SAVED OUTPBUF FOR ARP WAIT
OUTPLENSAV DS 2 ; SAVED OUTPLEN FOR ARP WAIT
*
*
* SENDER STORES HIS ARGUMENTS DIRECTLY IN OUTPHEAD
*
* IPPREP DOES PREPARATION WORK BEFORE SENDING THE IP
* PACKET. YOU NEED TO CALL THIS FIRST WHEN SENDING A
* UDP PACKET BECAUSE THE UDP CHECKSUM USES SOME DATA
* FROM THE IP HEAD.
IPPREP
 LDA #20 ; LENGTH OF IP HEAD
 STA IPHEADLEN
 CLC
 LDY #17 ; LOW-BYTE OF LENGTH
 LDA OUTPHEAD,Y
 ADC IPHEADLEN
 STA OUTPHEAD,Y
 DEY
 LDA OUTPHEAD,Y ; HIGH-BYTE
 ADC #0
 STA OUTPHEAD,Y
* ADD OUTPLEN
 CLC
 INY ; BACK TO LOW-BYTE OF LENGTH
 LDA OUTPHEAD,Y
 ADC OUTPLEN
 STA OUTPHEAD,Y
 DEY
 LDA OUTPHEAD,Y
 ADC OUTPLEN+1
 STA OUTPHEAD,Y
* DEFAULT TTL, IF NEEDED
 LDX #22 ; OFFSET TO TTL
 LDA OUTPHEAD,X
 BNE :LLTTL ; USER SPECIFIED TTL
* TTL CHANGES BASED ON IP CONFIGURATION
 LDX #30
 LDA OUTPHEAD,X
 AND #%11110000
 CMP #MCASTCLASS ; CHECK FOR MULTICAST
 BNE :SETTTL
 LDA #MCASTTTL
 LDX #22
 STA OUTPHEAD,X
 BNE :GENID ; ALWAYS TAKEN
:SETTTL
 LDX #22
 LDA IPCONFMODE
 AND #%10000010 ; DHCP CONFIGURED
 BNE :DHCPTTL
 LDA #MAXTTL
 STA OUTPHEAD,X
 BMI :GENID
:DHCPTTL
 LDA #STDTTL
 STA OUTPHEAD,X
* IF DESTINATION IS LINK LOCAL, FORCE TTL TO 255
:LLTTL
 LDX #30
 LDA OUTPHEAD,X
 CMP #169
 BNE :GENID
 INX
 LDA OUTPHEAD,X
 CMP #254
 BNE :GENID
 LDA #MAXTTL
 LDX #22
 STA OUTPHEAD,X
* GENERATE IDENTIFICATION IF NEEDED
:GENID LDX #18 ; OFFSET TO ID
 LDA OUTPHEAD,X
 INX
 ORA OUTPHEAD,X
 BNE :NEXT ; ID ALREADY SET
* ID IS NEEDED
 DEX
 INC RNDL
 LDA RNDL
 EOR OUTPLEN
 STA OUTPHEAD,X
 INC RNDH
 LDA RNDH
 INX
 STA OUTPHEAD,X
* VALIDATE SOURCE IP ADDRESS. IF IT'S NOT ALL ZEROS,
* COPY OUR CONFIGURED ADDRESS.
:NEXT
 LDY #26 ; OFFSET TO SOURCE ADDR
:SL LDA OUTPHEAD,Y
 BNE :SETADDR ; NOT ZERO, SO PUT OUR ADDRESS
 INY
 CPY #30
 BNE :SL
* SOURCE ADDR IS ALL ZEROES, SO GO TO CHECKSUM
 BEQ :NEXT2
* COPY OUR ADDRESS
:SETADDR
 LDY #26
 LDX #0
:SL2 LDA IPADDR,X
 STA OUTPHEAD,Y
 INY
 INX
 CPX #4
 BNE :SL2
* NOW GENERATE THE IP CHECKSUM
:NEXT2
 LDA #0 ; ZERO THE CHECKSUM
 LDY #24 ; OFFSET TO CHECKSUM
 STA OUTPHEAD,Y
 INY
 STA OUTPHEAD,Y
* SETUP THE POINTER
 CLC
 LDA #<OUTPHEAD
 ADC #ETHHLEN ; SKIP ETHERNET HEAD
 STA PTR
 LDA #>OUTPHEAD
 ADC #0
 STA PTR+1
 JSR IPHEADCHKSUM
* STORE THE CHECKSUM
 LDY #25
 STA OUTPHEAD,Y
 DEY
 LDA CHKSUM+1
 STA OUTPHEAD,Y
* OUTPHEAD NOW CONTAINS A FULL IP HEADER. WE ARE DONE HERE.
 RTS
*
* IPSEND
* THIS WILL DETERMINE WHETHER TO SEND THE PACKET TO THE
* ROUTER OR TO THE HOST ON THE SAME LINK. MAY INVOLVE
* AN ARP REQUEST, IN WHICH CASE THE PACKET WILL BE PUT
* ON HOLD UNTIL THE ARP REPLY COMES (USUALLY QUICK).
*
* MODIFIED FOR FIXED-DESTINATION INTERFACES - 07 AUG 16
*
IPSEND
 LDA ARPTRIES
 BEQ :SETLEN
 SEC  ; ONLY ALLOW 1 PENDING SEND OPERATION
 RTS
* PUT TOGETHER FINAL OUTPUT HEAD LENGTH
:SETLEN
 LDA #0
 STA OUTPBUFSAV
 STA OUTPBUFSAV+1
 STA OUTPLENSAV
 STA OUTPLENSAV+1
 CLC
 LDA IPHEADLEN
 ADC OUTPHLEN
 ADC #ETHHLEN ; ETHERNET HEAD
 STA OUTPHLEN
IPSEND2
* DOES THIS NETWORK INTERFACE HAVE A FIXED DESTINATION?
 LDA FIXEDDEST
 BEQ :CHECKDEST
 JMP :SETOUTPLEN
:CHECKDEST
* CHECK DESTINATION ADDRESS
 LDX #30 ; POINT TO DEST ADDR
 LDA OUTPHEAD,X
 CMP #127 ; LOCALHOST?
 BNE :N ; NO
 SEC
 RTS
:N
* RESTORE OUTPBUF AND OUTPLEN IF NECESSARY
 LDA ARPTRIES
 BEQ :NEXT
 LDA OUTPBUFSAV
 STA OUTPBUF
 LDA OUTPBUFSAV+1
 STA OUTPBUF+1
 LDA OUTPLENSAV
 STA OUTPLEN
 LDA OUTPLENSAV+1
 STA OUTPLEN+1
:NEXT
*
* MULTICAST DESTINATION
 LDA OUTPHEAD,X ; X STILL 30
 AND #%11110000 ; GET HIGH NYBBLE
 CMP #MCASTCLASS ; MULTICAST ADDRESS?
 BNE :CHECKBCAST ; NO, MOVE ON
 JMP :LOCALARP ; YES, SO SEND LOCALLY
*
* CHECK FOR BROADCAST DESTINATION
* FIRST CHECK ALL ONES, THEN CHECK NETBCAST
:CHECKBCAST
 LDA OUTPHEAD,X
 INX
 AND OUTPHEAD,X
 INX
 AND OUTPHEAD,X
 INX
 AND OUTPHEAD,X
 CMP #$FF ; LIMITED BROADCAST
 BEQ :BROADCAST
* CHECK NETBCAST - DIRECTED BROADCAST
 LDX #33 ; DEST OFFSET
 LDY #3 ; NETBCAST OFFSET
:NBCL LDA OUTPHEAD,X
 CMP NETBCAST,Y
 BNE :CHKROUTABLE
 DEX
 DEY
 BPL :NBCL
 BMI :BROADCAST
* CHECK FOR A ROUTABLE ADDRESS
:CHKROUTABLE
 LDA IPCONFMODE
 CMP #%10000010
 BEQ :ROUTABLE ; WE HAVE A ROUTABLE ADDRESS
* NON-ROUTABLE ADDRESS CONFIGURED
* WE CAN ONLY SEND TO OUR LOCAL LINK OR BROADCAST
* NOT BROADCAST, SO VERIFY DEST IS WITHIN LL NETWORK
 LDX #30
 LDA OUTPHEAD,X
 CMP #169
 BNE :BADLL
 INX
 LDA OUTPHEAD,X
 CMP #254
 BNE :BADLL
* CHECK FOR LL BROADCAST, OTHERWISE WE GO STRAIGHT TO ARP
 INX
:LLBCAST
 LDA OUTPHEAD,X
 CMP #255
 BNE :LOCALARP ; NOT BROADCAST, SO DO ARP LOOKUP
 INX
 LDA OUTPHEAD,X
 CMP #255
 BEQ :BROADCAST ; IT'S A BROADCAST
 BNE :LOCALARP ; DO ARP LOOKUP FOR THIS LL ADDR
* BAD DESTINATION ON LL ADDR
:BADLL
 SEC
 RTS
* DESTINATION VALID
* WE HAVE A ROUTABLE ADDRESS. CHECK IF WE SHOULD SEND
* THIS DATAGRAM ON THE LOCAL LINK.
:ROUTABLE
 LDA OUTPHEAD+30
 CMP #169 ; LINK-LOCAL DESTINATION?
 BNE :ROUTABLE2 ; NO, SO CHECK NETMASK
 LDA OUTPHEAD+31
 CMP #254
 BNE :ROUTABLE2 ; NOT A LINK-LOCAL DESTINATION
 LDX #32 ; CHECK FOR LL BROADCAST
 BNE :LLBCAST ; ALWAYS TAKEN
:ROUTABLE2
 LDX #3 ; NETMASKA OFFSET
 LDY #33 ; OUTPHEAD DEST ADDR OFFSET
:DESTL LDA OUTPHEAD,Y
 AND NETMASK,X
 CMP NETMASKA,X
 BNE :FORWARD ; FORWARD IT TO ROUTER
 DEY
 DEX
 BPL :DESTL
* IF WE GET HERE THEN WE CAN SEND DATAGRAM LOCALLY
 BMI :LOCALARP ; DO A LOCAL LOOKUP
* LOOKUP LOCAL ADDRESS OF OUR ROUTER
:FORWARD
 LDA #<ROUTER
 STA PTR
 LDA #>ROUTER
 STA PTR+1
 JMP :ARP ; GET ROUTER'S MAC ADDRESS
* SET BROADCAST MAC
:BROADCAST
 LDX #5 ; LAST DEST BYTE
 LDA #$FF
:BL STA OUTPHEAD,X
 DEX
 BPL :BL
 BMI :SETOUTPLEN ; GET READY TO SEND
* PERFORM A LOCAL ARP LOOKUP
:LOCALARP
 CLC
 LDA #<OUTPHEAD
 ADC #30 ; POINT TO DEST ADDR
 STA PTR
 LDA #>OUTPHEAD
 ADC #0
 STA PTR+1
* PERFORM AN ARP LOOKUP
:ARP
 JSR ARPLOOKUP
 BCS :ARPFAIL ; LOOKUP FAILED
 LDA #0
 STA ARPTRIES
* COPY MAC TO DESTINATION MAC
 INX
 INX
 INX
 INX ; POINT TO MAC IN ARPTAB
 LDY #0
:CML LDA ARPTAB,X
 STA OUTPHEAD,Y
 INX
 INY
 CPY #6
 BNE :CML
 BEQ :SETOUTPLEN
*
* WE NEED TO SEND AN ARP REQUEST.
*
:ARPFAIL
* CHECK AND SET NUMBER OF ARP TRIES
 DEC ARPTRIES
 BEQ :DONE ; GIVE UP WAITING FOR REPLY
 BPL :NEXTTRY
 LDA #6
 STA ARPTRIES
:NEXTTRY
* SAVE OUTPBUF BECAUSE ARPREQUEST WILL CHANGE IT
 LDA OUTPBUF
 STA OUTPBUFSAV
 LDA OUTPBUF+1
 STA OUTPBUFSAV+1
* AND SAVE OUTPLEN TOO
 LDA OUTPLEN
 STA OUTPLENSAV
 LDA OUTPLEN+1
 STA OUTPLENSAV+1
 JSR ARPREQUEST
 LDA #$FF
 JSR WAIT
 LDA #$FF
 JSR WAIT
:DONE
 SEC
 RTS
* RIGHT NOW OUTPLEN IS ONLY THE LENGTH OF THE USER'S
* DATA PAYLOAD. IT NEEDS TO BE EXTENDED TO ACCOUNT FOR
* THE VARIOUS PROTOCOL HEADERS.
* UPDATE OUTPLEN TO BE THE TOTAL LENGTH OF EVERYTHING.
:SETOUTPLEN
 CLC
 LDA IPHEADLEN ; LENGTH OF IP HEAD
 ADC #ETHHLEN ; ETHERNET LENGTH
 ADC OUTPLEN
 STA OUTPLEN
 LDA OUTPLEN+1
 ADC #0
 STA OUTPLEN+1
* ADD PROTOCOL HEAD LENGTH. ALWAYS UDP (8) FOR NOW.
 CLC
 LDA OUTPLEN
 ADC #8
 STA OUTPLEN
 LDA OUTPLEN+1
 ADC #0
 STA OUTPLEN+1
* SEND IT AWAY
 JSR ETHSEND16
*
 LDA #0
 STA ARPTRIES
 RTS
*
*
*
* IP CHECKSUM - THE MARINA IP STACK FOR APPLE IIE
* BY D. FINNIGAN - 17 FEB 2014
*
* THE CHECKSUM IS THE ONE'S COMPLEMENT OF THE 16-BIT
* ONE'S COMPLEMENT OF DATA. THIS MEANS ADD WITH CARRY.
*
* THIS CHECKSUM ROUTINE IS OPTIMIZED FOR 20-BYTE IP HEAD
*
* "PTR" SHOULD POINT TO THE FIRST BYTE TO BE CHECKSUMMED.
* THE COMPUTED CHECKSUM IS STORED IN "CHKSUM"
*
IPHEADCHKSUM
 LDA #0
 STA CHKSUM ; ZERO OUT 16-BIT CHKSUM
 STA CHKSUM+1
* ASSUME LENGTH OF 20 BYTES
 LDY #19 ; DATA POINTER
 CLC
* UNROLL THE LOOP
 LUP 10
 LDA (PTR),Y ; GET LO-BYTE
 ADC CHKSUM
 STA CHKSUM
 DEY
 LDA (PTR),Y
 ADC CHKSUM+1
 STA CHKSUM+1
 DEY
* END OF UNROLLED LOOP
 --^
*
* DO FINAL TRANSFORMATIONS
*
 BCC :FINAL
:CARRY LDA CHKSUM
 ADC #0
 STA CHKSUM
 BCC :FINAL
 LDA CHKSUM+1
 ADC #0
 STA CHKSUM+1
 BCS :CARRY
:FINAL LDA CHKSUM+1
 EOR #$FF
 STA CHKSUM+1
 LDA CHKSUM
 EOR #$FF
 STA CHKSUM
 RTS
*
